	function h = sincfilter(dec, casc, skew)
	%h = sincfilter(dec, casc, skew)
	%
	%Creates the impulse response of a cascaded moving average filter.
	%
	%Arguments:
	%  dec - number of ones in the moving average filter
	%  casc - number of moving average filters in cascade
	%  skew - number of leading zeroes in the impulse response
	%
	%Returns:
	%  h - the impulse response
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	if nargin < 3
		skew = 0;
	end
	
	g = ones(1, dec);
	h = 1;
	for c = 1:casc
		h = conv(h, g);
	end
	
	h = [zeros(1, skew) h];
	
